# Remote LS Server - Wouter Borremans 0461911

# Required libs
require 'etc'
require 'socket'
require 'timeout'

# Declare variabeles
portnumber = 12345
listener = TCPServer.new(portnumber)
serversession = 0
option1 = "0"											# Set the default options to nil
option2 = "0"											# Set the default options to nil

# Display welcome message
puts "Remote LS Server\n\n"

begin
	loop do
		puts "- Waiting for client to connect"							
		serversession = listener.accept							# Create a socket listener
		option1 = serversession.gets							# Get the first option through the socket
		option1 = option1.chomp()							# Remove escape characters etc.
		option2 = serversession.gets							# Get the second option through the socket
		option2 = option2.chomp()							# Remove escape characters etc.
		dirmessage = serversession.gets							# Get the directory which has to be listed
		directory = dirmessage.chomp()							# Remove escape characters
		
		begin
			files = Dir::entries(directory)						# Use the 'Dir' class to get the directory entries
			files.sort!								# Sort the files which come from the directory
			files.each { |f|							# Put each file into the 'f' variabele 
				# Check which options have to be executed
				if ("a".eql? option1) && ("l".eql? option2)
					s = File::stat(directory + "/" + f)
					# Print the file & directory structure
					serversession.print Etc.getpwuid(s.uid).name, "\t", Etc.getgrgid(s.gid).name, "\t", "#{s.size}", "\t", "#{s.ctime}", "\t", f.to_s, "\n"
	                       	end
				if ("a".eql? option1) && ("0".eql? option2)
					s = File::stat(directory + "/" + f)
					serversession.print Etc.getpwuid(s.uid).name, "\t", Etc.getgrgid(s.gid).name, "\t", "#{s.size}", "\t", "#{s.ctime}", "\t", f.to_s, "\n"				
				end
				if ("0".eql? option1) && ("l".eql? option2)
					s = File::stat(directory + "/" + f)
					serversession.print f.to_s, "\n"
				end
				if ("0".eql? option1) && ("0".eql? option2)
					s = File::stat(directory + "/" + f)
					serversession.print f.to_s, "\n"
				end
			}
		end
		serversession.close								# Close the current socket
		puts "- Directory \'#{directory}\' listed"
	end
rescue
puts "Remote LS Server ended, have a nice day!\n\n"	
end




