# Remote LS Server - Wouter Borremans 0461911
require 'timeout'
require 'socket'

# Declare variabeles
portnumber = 12345
hostname = '127.0.0.1'
option1 = 0
option2 = 0
directory = "."

# Check if there are some arguments given in
while ARGV.length > 0 and ARGV[0] =~ /^-/
	case ARGV[0]
        when '-a'
                option1 = "a";
	when '-l'
                option2 = "l";
	else
		print "\n\nRemote LS server Usage: #{$0} [-a] [-l] host dirname \n";
                exit
        end
        ARGV.shift
end

# Check if the arguments consist of only characters and numbers (using regular expressions)
if ARGV[0] =~ /^[a-zA-Z0-9]/
        hostname = ARGV[0]
else
        print "Remote LS Server usage: #{$0} [-a] [-l] host dirname \n";
        exit
end

begin
timeout(1) do
                begin
			# Create a socket connection to a specific port and host
                        connection = TCPSocket.new(hostname, portnumber)
                rescue
                        print "error: #{$!} \n"
                        print "\nERROR: Could not connect to server.\n\n"
                        exit
		end

		# Send the arguments to the server
		connection.puts option1
                connection.puts option2
                directory = ARGV[1]
		connection.puts directory
                begin
                        files = connection.gets(nil)
                rescue
                        print "error: #{$!} \n"
                end
		puts "Directory listing for: #{directory}\n\n"
                puts files
                connection.close
	end
rescue
	puts "\n\n Bye Bye, yours, Remote LS server"
        listener.close

end
