#########################################################################################
# Distributed Ruby Bioscoop Reserveringen v1.0 - Wouter Borremans 0461911               #
#########################################################################################

require 'drb/drb'
require 'front'
require 'placeobject'

# The URI used for Distributed Ruby
SERVER_URI = "druby://localhost:8787"
		
class FrontOfficeFactory 
	
	def initialize
		# Show a little interface to display data properly
		system('clear')
		puts "============================================================================================="
		puts "Front Office Object Factory"
		puts "============================================================================================="
		puts ""
		puts "[#{Time.now}] - Object Factory Started"

		# Create hash to store factory objects
		@frontOffice = Hash.new
		@frontOfficeHistory = Hash.new
	end
	
	# Function to create objects which can be used for booking
	def getFrontOffice(officeName)
		@officeName = officeName
		if !@frontOffice.has_key? @officeName
			@frontOffice[@officeName] = FrontOffice.new(@officeName)		
			puts "[#{Time.now}] - Front Office Object Created for '#{officeName}'"
			if !@frontOfficeHistory.has_key? @officeName
				@frontOfficeHistory[@officeName] = 1
			end
		end
		if @frontOfficeHistory.has_key? @officeName
			puts "[#{Time.now}] - Using Front Office Object '#{officeName}' to manipulate a booking"
		end 
	return @frontOffice[@officeName]
	end
end

# Create a Distributed Ruby server
SERVER_OBJECT = FrontOfficeFactory.new
DRb.start_service(SERVER_URI, SERVER_OBJECT)
DRb.thread.join

