require 'drb/drb'

# Global constants
SEATPRICE = 7.50
MAXIMUMSEATS = 10

class FrontOffice
	include DRb::DRbUndumped
	
	# Define default variabeles
	def initialize ( officename )
		@officename = officename
		@seatTaken = Hash.new
		@seatCreditCard = Hash.new
		@maximumSeats = MAXIMUMSEATS	
	end

	# Function to return 
	def getSeatPrice(row,seat)
		@row = row
		@seat = seat

		# At the moment only one price for each seat
		return SEATPRICE
	end
	
	def bookSingleSeat(row,seat,creditCard)
		@row = row
		@seat = seat
		@creditCard = creditCard
		@seatCreditCardIdentifier = "@row" + "@seat"
		
		# Check if there are still some seats available
			# Check if the row that has been choosen already has some seats occupied
		#if !@maximumSeats == 0
			if @seatTaken.has_key? @row
				# Check if a specific seat in a row has already been taken
				if @seatTaken[@row] == @seat
				return "SEAT_TAKEN"
				else 
					@seatTaken[@row] = @seat
					@maximumSeats = @maximumSeats - 1
					@seatCreditCard[@seatCreditCardIdentifier] = @creditCard
				return "SEAT_BOOKED"				
				end
			else
				@seatTaken[@row] = @seat
				@maximumSeats = @maximumSeats - 1
			return "SEAT_BOOKED"
			end
		#return "NO_SEATS"
		#end
			
	end
end



