#########################################################################################
# Distributed Ruby Bioscoop Reserveringen v1.0 - Wouter Borremans 0461911		#
#########################################################################################

require 'drb/drb'
SERVICE_URI = "druby://localhost:8787"

# Start factory pattern
begin
	DRb.start_service()
	obj = DRbObject.new(nil, SERVICE_URI)
rescue
	puts ""
	puts "[#{Time.now}] - Kan geen Drb service starten"
	puts ""
	exit(1)
end

while true
	# Clear the screen
	system('clear')

	# Display menu interface
	puts "======================================================" 
	puts "Bioscoop reserveringen "
	puts "======================================================"
	puts ""	
	puts "Maak uw keuze"
	puts ""
	puts "1) Reserveer een stoel"
	puts "2) Bekijk stoelprijs"
	puts "3) Sluit programma af"
	puts ""
	puts "======================================================"

	# Catch the user input and remove untwanted data
	optionchoosen = STDIN.gets().chomp!

	# Function to get default user input
	def getUserData()
		# Clear the screen
		system('clear')
	        puts "======================================================"
	        puts "Bioscoop reserveringen "
	        puts "======================================================"
	        puts ""
		puts "Voer de bioscoopnaam in:"
		strCinemaName = gets().chomp!
		puts "Voer het rijnummer in:"
		strRowNumber = gets().chomp!
		puts "Voer het stoelnummer in:"
		intSeatNumber = gets().chomp!

		# Fill an array with the data filled in
		arData = Array.new
		arData[0] = strCinemaName
		arData[1] = strRowNumber
		arData[2] = intSeatNumber

	# Return the array back to the function
	return arData
	end
	
	case optionchoosen
		when "1"
			# Get the data of the user
			arDataReturned = getUserData()
			
			# Get credit card number
	                puts "Voer het creditcard nummer in:"
	                intCreditCardNumber = gets().chomp!
			
			# Create a new instance of FrontOffice using the Object Factory
			begin
				frontOffice = obj.getFrontOffice(arDataReturned[0])	
				# Place a booking and get the result back
				strBookSeatStatus = frontOffice.bookSingleSeat(arDataReturned[1],arDataReturned[2],intCreditCardNumber)
				
			rescue DRb::DRbError
				system('clear');
			        puts ""
			        puts "[#{Time.now}] - Kan geen verbinding maken met de Object Factory op het volgende adres:  #{SERVICE_URI}"
			        puts ""
			        exit(1)
			end
			
			# Check if the seat is already taken
			if "SEAT_TAKEN".eql? strBookSeatStatus
				system('clear')
		                puts "======================================================"
                		puts "Bioscoop reserveringen [#{arDataReturned[0]}]"
				puts "======================================================"
				puts ""
				puts "Sorry, stoel -#{arDataReturned[1]}#{arDataReturned[2]}- in bioscoop '#{arDataReturned[0]}' is al bezet!"
			end
			if "SEAT_BOOKED".eql? strBookSeatStatus
				system('clear')
		                puts "======================================================"
		                puts "Bioscoop reserveringen [#{arDataReturned[0]}]"
		                puts "======================================================"
		                puts ""
				puts "Gefelicieerd, stoel -#{arDataReturned[1]}#{arDataReturned[2]}- in bioscoop '#{arDataReturned[0]}' is geboekt."
			end
                        if "NO_SEATS".eql? strBookSeatStatus
                                system('clear')
                                puts "======================================================"
                                puts "Bioscoop reserveringen [#{arDataReturned[0]}]"
                                puts "======================================================"
                                puts ""
                                puts "Sorry, Er zijn geen plaatsen in bioscoop '#{arDataReturned[0]}' meer vrij."
	                end
			
			puts ""
			puts "Druk op [ENTER] om verder te gaan"
			puts ""
			gets
			
		when "2"
			# Get Data from the user
			arDataReturned = getUserData()
			
			# Create an factory object for price check
			begin
				frontOffice = obj.getFrontOffice(arDataReturned[0])
				seatPrice = frontOffice.getSeatPrice(arDataReturned[1],arDataReturned[2])
			rescue
                                system('clear');
                                puts ""
                                puts "[#{Time.now}] - Kan geen verbinding maken met de Object Factory op het volgende adres:  #{SERVICE_URI}"
                                puts ""
                                exit(1)
			end
			system('clear')
                        puts "======================================================"
                        puts "Bioscoop reserveringen "
                        puts "======================================================"
                        puts ""
			puts "De prijs voor de stoel -#{arDataReturned[1]}#{arDataReturned[2]}- in bioscoop '#{arDataReturned[0]}' is: #{seatPrice}"
			puts ""
			puts "Druk op [ENTER] om door te gaan"
			gets

		when "3"
			system('clear')
			puts "" 
			puts "Thanks for using this program."
			puts ""
			exit(0)
	else
		puts "Wrong choice press [ENTER]"
		gets
	end
end
